/**
 * OWASP AppSensor
 * 
 * This file is part of the Open Web Application Security Project (OWASP)
 * AppSensor project. For details, please see
 * <a href="http://www.owasp.org/index.php/Category:OWASP_AppSensor_Project">
 * 	http://www.owasp.org/index.php/Category:OWASP_AppSensor_Project</a>.
 *
 * Copyright (c) 2010 - The OWASP Foundation
 * 
 * AppSensor is published by OWASP under the BSD license. You should read and accept the
 * LICENSE before you use, modify, and/or redistribute this software.
 * 
 * @author Michael Coates <a href="http://www.aspectsecurity.com">Aspect Security</a>
 * @author John Melton <a href="http://www.jtmelton.com/">jtmelton</a>
 * @created 2010
 */
namespace org.owasp.appsensor
{

    using System;
    using System.Web;


    /**
     * This interface specifies the requirements for a utilities implementation that is used in
     * AppSensor.  The utilities are a convenient location to specify the instantiation of those
     * objects that are either minimal in usage or are not the core objects of AppSensor (ie. 
     * response action, intrusion store, etc.).  Various objects created here do rely on AppSensor
     * specific interfaces, however there are default implementations, at least using Esapi, that 
     * will allow immediate usage of the system if Esapi is also being used.  If Esapi is not being
     * used by your application and you would still like to use AppSensor, you'll either have to 
     * use another default implementation if one exists, or write your own implementation of 
     * these interfaces, which in many cases may be trivial.
     * 
     * @author Michael Coates (michael.coates .at. owasp.org) 
     *         <a href="http://www.aspectsecurity.com">Aspect Security</a>
     * @author John Melton (jtmelton .at. gmail.com)
     *         <a href="http://www.jtmelton.com/">jtmelton</a>
     * @since May 6, 2010
     */

    public interface ASUtilities
    {

        /**
         * This method retrieves the current user implementation
         * @return current user implementation
         */
        ASUser CurrentUser { get; }

        /**
         * This method retrieves the logger implementation
         * @param className The module to associate the logger with.
         * @return logger implementation
         */
        ASLogger GetLogger(String className);

        /**
         * Retrieves the current HttpServletRequest
         * @return the current request
         */
        HttpRequest GetCurrentRequest();
    }
}